/*
 * Decompiled with CFR 0.152.
 */
package run;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundClass {
    Object currentSound;
    String currentName;
    Clip SoundClip;
    AudioInputStream stream;
    AudioFormat format;
    File soundFile;
    private static final int EXTERNAL_BUFFER_SIZE = 128000;

    public SoundClass(String string) {
        try {
            this.soundFile = new File(string);
            this.currentSound = SoundClass.createClip(this.soundFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Clip createClip(File file) {
        try (AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);){
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
            Clip clip2 = (Clip)AudioSystem.getLine(info);
            clip2.open(audioInputStream);
            Clip clip = clip2;
            return clip;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
        }
        return null;
    }

    public void loopSound() {
        try {
            if (this.SoundClip != null) {
                this.SoundClip.setFramePosition(0);
                this.SoundClip.stop();
            } else {
                this.SoundClip = (Clip)this.currentSound;
            }
            this.SoundClip.loop(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    public void playSound() {
        try {
            if (this.SoundClip != null) {
                this.SoundClip.setFramePosition(0);
                this.SoundClip.stop();
            } else {
                this.SoundClip = (Clip)this.currentSound;
            }
            this.SoundClip.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    public void closeSound() {
        try {
            if (this.SoundClip != null) {
                this.SoundClip.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    public void stopSound() {
        try {
            if (this.SoundClip != null) {
                this.SoundClip.setFramePosition(0);
                this.SoundClip.stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }
}

