/*
 * Decompiled with CFR 0.152.
 */
package run;

import java.io.BufferedInputStream;
import java.io.File;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;

public class MidiClass
extends Thread {
    long midi_spool_time = 0L;
    boolean soundflag = false;
    boolean endflag = true;
    Sequencer sequencer;
    Synthesizer synthesizer;
    MidiChannel[] channels;
    Object currentSound;
    File midiFile;
    private static final int EXTERNAL_BUFFER_SIZE = 128000;

    public MidiClass() {
        this.start();
    }

    public Object loadSound(String string) {
        return this.loadSound(string, false);
    }

    public Object loadSound(String string, boolean bl) {
        this.midi_spool_time = bl && this.midiFile != null && this.sequencer != null ? this.sequencer.getTickPosition() : 0L;
        this.soundflag = false;
        this.stopSound();
        this.closeSound();
        try {
            this.sequencer = MidiSystem.getSequencer();
            if (this.sequencer instanceof Synthesizer) {
                this.synthesizer = (Synthesizer)((Object)this.sequencer);
                this.channels = this.synthesizer.getChannels();
                int n = 100;
                for (int i = 0; i < this.channels.length; ++i) {
                    this.channels[i].controlChange(10, (int)(((double)n + 100.0) / 200.0 * 90.0));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        this.midiFile = new File(string);
        try {
            this.currentSound = MidiSystem.getSequence(this.midiFile);
            System.out.println("MIDI file.");
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.out.println("Unsupported audio file.");
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
            return null;
        }
        if (this.sequencer == null) {
            this.currentSound = null;
            return null;
        }
        if (this.currentSound instanceof Sequence || this.currentSound instanceof BufferedInputStream) {
            try {
                this.sequencer.open();
                if (this.currentSound instanceof Sequence) {
                    this.sequencer.setSequence((Sequence)this.currentSound);
                } else {
                    this.sequencer.setSequence((BufferedInputStream)this.currentSound);
                }
                System.out.println("MIDI file open.");
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                System.out.println("Unsupported audio file.");
                this.currentSound = null;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentSound = null;
                return null;
            }
        }
        this.soundflag = true;
        return this.currentSound;
    }

    @Override
    public void run() {
        while (true) {
            if (this.soundflag && this.sequencer != null && this.sequencer.isOpen()) {
                if (this.sequencer.getMicrosecondLength() > this.sequencer.getMicrosecondPosition()) continue;
                System.out.println("Midi Loop.");
                this.sequencer.setTickPosition(1L);
                this.sequencer.start();
                continue;
            }
            try {
                Thread.sleep(99L);
            }
            catch (Exception exception) {
                System.out.println("run error!" + exception);
                return;
            }
        }
    }

    public Object getSound() {
        return this.sequencer;
    }

    public void loopSound() {
        this.soundflag = true;
        this.startSound();
    }

    public void startSound() {
        try {
            this.sequencer.stop();
            this.sequencer.setTickPosition(this.midi_spool_time);
            this.sequencer.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    public void playSound() {
        try {
            if (this.sequencer != null) {
                this.soundflag = false;
                this.sequencer.stop();
                this.sequencer.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    public void stopSound() {
        try {
            if (this.sequencer != null) {
                this.sequencer.stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    public void closeSound() {
        try {
            if (this.sequencer != null) {
                this.sequencer.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }
}

