/*
 * Decompiled with CFR 0.152.
 */
package run;

import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;

public class SoundClass {
    Object currentSound;
    String currentName;
    Clip SoundClip;
    AudioInputStream stream;
    AudioFormat format;
    URL url;
    private static final int EXTERNAL_BUFFER_SIZE = 128000;

    public SoundClass(URL uRL, String string) {
        try {
            this.url = new URL(uRL, string);
            this.loadSound();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    public void loadSound() {
        try {
            Object object;
            this.currentSound = AudioSystem.getAudioInputStream(this.url);
            this.stream = (AudioInputStream)this.currentSound;
            this.format = this.stream.getFormat();
            if (this.format.getEncoding() == AudioFormat.Encoding.ULAW || this.format.getEncoding() == AudioFormat.Encoding.ALAW) {
                object = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.format.getSampleRate(), this.format.getSampleSizeInBits() * 2, this.format.getChannels(), this.format.getFrameSize() * 2, this.format.getFrameRate(), true);
                this.stream = AudioSystem.getAudioInputStream((AudioFormat)object, this.stream);
                this.format = object;
            }
            object = new DataLine.Info(Clip.class, this.stream.getFormat(), (int)this.stream.getFrameLength() * this.format.getFrameSize());
            Clip clip = (Clip)AudioSystem.getLine((Line.Info)object);
            clip.open(this.stream);
            this.currentSound = clip;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    public void loopSound() {
        try {
            if (this.SoundClip != null) {
                this.SoundClip.setFramePosition(0);
                this.SoundClip.stop();
            } else {
                this.SoundClip = (Clip)this.currentSound;
            }
            this.SoundClip.loop(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    public void playSound() {
        try {
            if (this.SoundClip != null) {
                this.SoundClip.setFramePosition(0);
                this.SoundClip.stop();
            } else {
                this.SoundClip = (Clip)this.currentSound;
            }
            this.SoundClip.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    public void closeSound() {
        try {
            if (this.SoundClip != null) {
                this.SoundClip.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }

    public void stopSound() {
        try {
            if (this.SoundClip != null) {
                this.SoundClip.setFramePosition(0);
                this.SoundClip.stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentSound = null;
        }
    }
}

